<?php
/**
 * Template part for displaying single team post
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package foresty
 */

$foresty = foresty();
$foresty_meta = get_post_meta(get_the_ID(), 'foresty_team_options', true);
$img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
$img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'full', false) : '';
$img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
$img_alt = $img_id ? get_post_meta($img_id, '_wp_attachment_image_alt', true) : '';
$designation = isset($foresty_meta['designation']) && !empty($foresty_meta['designation']) ? $foresty_meta['designation'] : '';
$description = isset($foresty_meta['description']) && !empty($foresty_meta['description']) ? $foresty_meta['description'] : '';
$social_icons = isset($foresty_meta['social-icons']) && !empty($foresty_meta['social-icons']) ? $foresty_meta['social-icons'] : '';
$team_info = isset($foresty_meta['team-info']) && !empty($foresty_meta['team-info']) ? $foresty_meta['team-info'] : '';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('foresty-details-content-area team-details-section'); ?>>
	<div class="team-details-page">
        <div class="container custom-container">
            <div class="row g-4 justify-content-center">
                <div class="col-lg-4 col-md-6">
                    <div class="team-single__image">
                        <img class="w-100" src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>">
                        <div class="team-info">
                            <?php
                                if (!empty($social_icons)) {
                                    foreach ($social_icons as $item) {
                                        printf('<a class="d-block" href="%1$s"><i class="%2$s"></i></a>', $item['url'], $item['icon']);
                                    }
                                }
                            ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="team-single__content">
                        <div class="title pb-30 mb-30 bor-bottom">
                            <h3><?php echo get_the_title(); ?></h3>
                            <span class="primary-color mt-1"><?php echo esc_html($designation); ?></span>
                        </div>
                        <div class="team-single__info">
                            <h4 class="pb-3"><?php echo esc_html('About Me', 'foresty'); ?></h4>
                            <p><?php echo esc_html($description); ?></p>
                            <div class="skills mt-65">
                                <div class="row g-4">
                                    <?php
                                        if (!empty($team_info)) {
                                            foreach ($team_info as $item) { ?>
                                                <div class="col-md-6">
                                                    <div class="experience-progress-wrapper">
                                                        <div class="experience-progress pb-4">
                                                            <div
                                                                class="experience-title-wrapper d-flex align-items-center justify-content-between">
                                                                <h5 class="experience-title pb-2"><?php echo esc_html($item['title']); ?></h5>
                                                                <span class="exp" style="left:<?php echo esc_html($item['count']); ?>%"><?php echo esc_html($item['count']); ?>%</span>
                                                            </div>
                                                            <div class="progress">
                                                                <div class="progress-bar wow slideInLeft"
                                                                    data-wow-duration=".8s" role="progressbar"
                                                                    style="width: <?php echo esc_html($item['count']); ?>%;" aria-valuenow="<?php echo esc_html($item['count']); ?>" aria-valuemin="0"
                                                                    aria-valuemax="100"></div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php }
                                        }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</div>
    <div class="entry-content">
        <?php
        the_content();
        $foresty->link_pages();
        ?>
    </div>
</article><!-- #post-<?php the_ID(); ?> -->