<?php
/**
 * Footer Style 01
 * @package foresty
 * @since 1.0.0
 */

$copyright_text = !empty(cs_get_option('copyright_text')) ? cs_get_option('copyright_text') : esc_html__('© 2023 . All Rights Reserved Foresty', 'foresty');
$copyright_text = str_replace('{copy}', '&copy;', $copyright_text);
$footer_two_bg = cs_get_option('footer_two_bg');
$footer_two_widget_bg = cs_get_option('footer_two_widget_bg');
$footer_two_logo = cs_get_option('footer_two_logo');
$footer_two_shortcode = cs_get_option('footer_two_shortcode');
$footer_two_social_item_repeater = cs_get_option('footer_two_social_item_repeater');

if (!empty($footer_two_bg['url'])) {
    $footer_two_bg_img = $footer_two_bg['url'];
}else {
    $footer_two_bg_img = "";
}

if (!empty($footer_two_widget_bg['url'])) {
    $footer_two_widget_bg_img = $footer_two_widget_bg['url'];
}else {
    $footer_two_widget_bg_img = "";
}
?>
<!-- footer area start -->
<footer class="footer">
    <div class="our-info bg-black bg-cover" data-background="<?php echo esc_url($footer_two_bg_img, 'foresty'); ?>">
        <div class="container">
            <div class="row align-items-center">
                <?php if (!empty($footer_two_logo['url'])) { ?>
                    <div class="col-lg-3 wow fadeInUp" data-wow-duration="1.4s" data-wow-delay=".4s">
                        <a href="<?php echo esc_url(get_home_url()); ?>" class="our-info__logo mb-4 mb-lg-0">
                            <img src="<?php echo esc_url($footer_two_logo['url']); ?>" alt="<?php echo esc_html('logo', 'foresty'); ?>">
                        </a>
                    </div>
                <?php } ?>
                <?php if (!empty($footer_two_shortcode)) { ?>
                    <div class="mt-lg-0 mt-4 mb-xl-0 mb-4 col-lg-5 wow fadeInDown" data-wow-duration="1.6s" data-wow-delay=".6s">
                        <?php echo do_shortcode($footer_two_shortcode); ?>
                    </div>
                <?php } ?>
                <?php  if (!empty($footer_two_social_item_repeater)) { ?>
                    <div class="col-lg-4">
                        <div class="our-info__social-icon float-lg-end float-none mt-4 mt-lg-0">
                            <?php foreach ($footer_two_social_item_repeater as $social_item) { ?>
                                <a href="<?php echo esc_url($social_item['footer_two_social_item_url'], 'foresty'); ?>" target="_blank">
                                    <i class="<?php echo esc_html($social_item['footer_two_social_item_icon'], 'foresty'); ?>"></i>
                                </a>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
    <div class="pd-top-115 pd-bottom-80 bg-cover" data-background="<?php echo esc_url($footer_two_widget_bg_img, 'foresty'); ?>">
        <div class="container">
            <div class="row">
                <?php dynamic_sidebar('footer-widget'); ?>
            </div>
        </div>
    </div>
    <div class="footer__copyright">
        <div class="container">
            <div class="row align-items-center gaper">
                <div class="col-12">
                    <div class="footer__copyright-text text-center">
                        <p class="text-senary tertiary-text mb-0">
                            <?php echo wp_kses($copyright_text, foresty()->kses_allowed_html(array('a'))); ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->