<?php
/**
 * Theme Default Header Two
 * @package foresty
 * @since 1.0.0
 */
?>
<?php
    $header_two_mail      = cs_get_option('header_two_mail');
    $header_two_location  = cs_get_option('header_two_location');
    $header_two_facebook  = cs_get_option('header_two_facebook');
    $header_two_twitter   = cs_get_option('header_two_twitter');
    $header_two_instagram = cs_get_option('header_two_instagram');
    $header_two_linkedin  = cs_get_option('header_two_linkedin');
?>

<div class="position-relative">
<div class="topbar-area d-lg-block d-none">  
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <ul class="topbar-inner-list"> 
                    <?php if (!empty($header_two_mail)) { ?>
                        <li><i class="fa fa-paper-plane"></i><?php echo esc_html($header_two_mail); ?></li>
                    <?php } ?>
                    <?php if (!empty($header_two_location)) { ?>
                        <li><i class="fa fa-map-marker-alt"></i><?php echo esc_html($header_two_location); ?></li>
                    <?php } ?>
                </ul>   
            </div>
            <div class="col-lg-4">
                <ul class="topbar-socail-list p-0 m-0 text-lg-end">
                    <?php if (!empty($header_two_facebook)) { ?>
                        <li><a href="<?php echo esc_html($header_two_facebook); ?>"><i class="fa fa-facebook"></i></a></li>
                    <?php } ?>
                    <?php if (!empty($header_two_twitter)) { ?>
                        <li><a href="<?php echo esc_html($header_two_twitter); ?>"><i class="fa fa-twitter"></i></a></li>
                    <?php } ?>
                    <?php if (!empty($header_two_instagram)) { ?>
                        <li><a href="<?php echo esc_html($header_two_instagram); ?>"><i class="fa fa-instagram"></i></a></li>
                    <?php } ?>
                    <?php if (!empty($header_two_linkedin)) { ?>
                        <li><a href="<?php echo esc_html($header_two_linkedin); ?>"><i class="fa fa-linkedin"></i></a></li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </div>
</div>  

<nav class="navbar navbar-area navbar-expand-lg navigation-style-01 navbar-style-01 navbar-default pt-2 pb-2">
    <div class="container custom-container">
        <div class="responsive-mobile-menu">
            <div class="logo-wrapper">
                <?php
                $header_two_logo = cs_get_option('header_two_logo');
                if (has_custom_logo() && empty($header_two_logo['id'])) {
                    the_custom_logo();
                } elseif (!empty($header_two_logo['id'])) {
                    printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_two_logo['url'], $header_two_logo['alt']);
                } else {
                    printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                }
                ?>
            </div>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#foresty_main_menu" aria-controls="foresty_main_menu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
        </div>
        <?php if (foresty()->is_foresty_core_active()) { 
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav text-lg-center',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'foresty_main_menu',
                'fallback_cb' => 'foresty_theme_fallback_menu',
            ));
        }else {
            wp_nav_menu(array(
                'theme_location' => 'main-menu',
                'menu_class' => 'navbar-nav',
                'container' => 'div',
                'container_class' => 'collapse navbar-collapse',
                'container_id' => 'foresty_main_menu',
                'fallback_cb' => 'foresty_theme_fallback_menu',
            ));
        } ?>
        <?php if (foresty()->is_foresty_core_active()) : ?>
            <div class="nav-right-part nav-right-part-desktop align-self-center">
                <?php
                    $header_right_btn_text = cs_get_option('header_right_btn_text');
                    $header_right_btn_url = cs_get_option('header_right_btn_url');
                ?>
                <a class="btn btn-base border-radius-5 header_two_btn" href="<?php echo esc_url($header_right_btn_url); ?>"><?php echo esc_html($header_right_btn_text); ?> <i class="fa fa-angle-double-right"></i></a>
            </div>
        <?php endif; ?>
    </div>
</nav>
</div>