<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Animal_Slider_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-animal-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Animal Slider 01', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control(
            'title', [
                'label' => esc_html__('title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'btn_text', [
                'label' => esc_html__('btn_text', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'btn_url', [
                'label' => esc_html__('btn_url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('animal_slider_items', [
            'label' => esc_html__('animal slider Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $animal_slider_items = $settings['animal_slider_items'];
        ?>

        <div class="animal">
            <div class="container">
                <div class="blog__head-wrp mb-65">
                    <div class="arry-btn mt-4 mt-lg-0">
                        <button class="arry-prev animal__arry-prev wow fadeInUp" data-wow-duration="1.6s"
                            data-wow-delay=".6s"><i class="fa-light fa-chevron-left"></i></button>
                        <button class="ms-3 active arry-next animal__arry-next wow fadeInUp" data-wow-duration="1.8s"
                            data-wow-delay=".8s"><i class="fa-light fa-chevron-right"></i></button>
                    </div>
                </div>
                <div class="swiper animal-gallery__slider">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="service-three__item animal-gallery__item">
                                <div class="image">
                                    <img src="assets/images/gallery/animal1.jpg" alt="image">
                                </div>
                                <div class="info">
                                    <h3 class="mb-30"><a href="#0">Tiger</a></h3>
                                    <a class="service-three__btn" href="#0">Details now <i
                                            class="fa-solid ps-2 fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Animal_Slider_One_Widget());