<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Banner_Five_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-banner-five-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner five', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('shape_1',
            [
                'label' => esc_html__('shape 1', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('shape_2',
            [
                'label' => esc_html__('shape 2', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('arrow_left',
            [
                'label' => esc_html__('arrow left', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('arrow_right',
            [
                'label' => esc_html__('arrow right', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control(
            'subtitle',
            [
                'label' => esc_html__('sub Title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Embrace the Green, Sow the Future', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('We Are Here to Increase Your <br> modern life With planting', 'foresty-core')
            ]
        );
        $repeater->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Discover With Us', 'foresty-core'),
        ]);
        $repeater->add_control('btn_url', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
        ]);
        $this->add_control('banner_items', [
            'label' => esc_html__('banner Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $banner_items = $settings['banner_items'];
        ?>

        <div class="banner-three">
            <button class="image-arry banner-three__arry-prev">
                <i data-background="<?php echo $settings['arrow_left']['url']; ?>" class="fa-light fa-chevron-left"></i>
            </button>
            <button class="image-arry banner-three__arry-next">
                <i data-background="<?php echo $settings['arrow_right']['url']; ?>" class="fa-light fa-chevron-right"></i>
            </button>
            <div class="banner-three__line-left d-none d-sm-block wow slideInLeft" data-wow-duration="1.4s"
                data-wow-delay="1s">
                <img src="<?php echo $settings['shape_1']['url']; ?>" alt="line-shape">
            </div>
            <div class="banner-three__line-right d-none d-sm-block wow slideInRight" data-wow-duration="1.4s"
                data-wow-delay="1.4s">
                <img src="<?php echo $settings['shape_2']['url']; ?>" alt="line-shape">
            </div>
            <div class="swiper banner-three__slider">
                <div class="swiper-wrapper">
                    <?php foreach ($banner_items as $items) { ?>
                        <div class="swiper-slide">
                            <div class="slide-bg" style="background-image: url('<?php echo $items['main_img']['url']; ?>');"></div>
                            <div class="container">
                                <div class="banner-three__content">
                                    <h4 data-animation="fadeInUp" data-delay="1s"><?php echo $items['subtitle']; ?></h4>
                                    <h1 data-animation="fadeInUp" data-delay="1.3s"><?php echo $items['title']; ?></h1>
                                    <div class="btn-wrap d-block">
                                        <a href="<?php echo $items['btn_url']; ?>" class="btn-one-white mt-50 d-inline-block" data-animation="fadeInUp"
                                        data-delay="1.8s"><span><?php echo $items['btn_text']; ?></span> <i
                                            class="fa-solid fa-angles-right"></i></a> 
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Banner_Five_Widget());