<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Banner_Four_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-banner-four-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner four', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('shape_1',
            [
                'label' => esc_html__('shape 1', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('shape_2',
            [
                'label' => esc_html__('shape 2', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('video_shape',
            [
                'label' => esc_html__('video_shape', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater->add_control(
            'subtitle',
            [
                'label' => esc_html__('sub Title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Embrace the Green, Sow the Future', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Leading the way to a greener future', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'content',
            [
                'label' => esc_html__('content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter content.', 'foresty-core'),
                'default' => esc_html__('Ecology is the scientific study of the relationships between organisms and their environment, including their physical, chemical', 'foresty-core')
            ]
        );
        $repeater->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Discover With Us', 'foresty-core'),
        ]);
        $repeater->add_control('btn_url', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
        ]);
        $this->add_control('banner_items', [
            'label' => esc_html__('banner Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $banner_items = $settings['banner_items'];
        ?>

        <div class="banner-two bor-bottom">
            <div class="banner-two__shape-left wow slideInLeft d-none d-xl-block" data-wow-duration="1s"
                data-wow-delay="1s"><img src="<?php echo $settings['shape_1']['url']; ?>" alt="shape"></div>
            <div class="banner-two__shape-right wow slideInRight d-none d-xl-block" data-wow-duration="1.2s"
                data-wow-delay="1.2s"><img src="<?php echo $settings['shape_2']['url']; ?>" alt="shape">
            </div>
            <div class="swiper banner-two__slider">
                <div class="swiper-wrapper">
                    <?php foreach ($banner_items as $items) { ?>
                        <div class="swiper-slide">
                            <div class="banner-two__image bg-image" style="background-image: url('<?php echo $items['main_img']['url']; ?>');"></div>
                        </div>
                    <?php } ?>
                </div>
            </div>
            <div class="container">
                <div class="banner-two__content pt-190 pb-190">
                    <div class="swiper banner-slider">
                        <div class="swiper-wrapper">
                            <?php foreach ($banner_items as $items) { ?>
                                <div class="swiper-slide">
                                    <h4 data-animation="fadeInUp" data-delay="0.4s"><?php echo $items['subtitle']; ?></h4>
                                    <h1 data-animation="fadeInUp" data-delay=".8s"><?php echo $items['title']; ?></h1>
                                    <p class="mt-55 mb-55" data-animation="fadeInUp" data-delay="1.2s"><?php echo $items['content']; ?></p>
                                    <div class="btn-wrap">
                                        <a data-animation="fadeInUp" data-delay="1.6s" href="<?php echo $items['btn_url']; ?>" class="btn-one d-inline-block"><span><?php echo $items['btn_text']; ?></span> <i class="fa-solid fa-angles-right"></i></a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="dot-light banner-two__dot"></div>
            <a class="text-btn d-none d-sm-inline-block banner-two__video-btn video-popup"
                href="https://www.youtube.com/watch?v=Cn4G2lZ_g2I">
                <i class="fa-duotone fa-play"></i>
                <div class="the-text">
                    <img src="<?php echo $settings['video_shape']['url']; ?>" alt="text-image">
                </div>
            </a>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Banner_Four_Widget());