<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Banner_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-banner-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner One', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('left_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('left_stock_img',
            [
                'label' => esc_html__('Stock Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('sub Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Embrace The Green, Sow The Future', 'foresty-core')
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('We Are Here To Increase Your Modern Life With Planting', 'foresty-core')
            ]
        );
        $this->add_control('content',
            [
                'label' => esc_html__('Description', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Ecology Is The Scientific Study Of The Relationships Between Organisms & Their Environment, Including Their Physical, Chemical', 'foresty-core')
            ]
        );
        $this->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Discover with us', 'foresty-core'),
        ]);
        $this->add_control('btn_url', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
        ]);
        $this->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('shape_img',
            [
                'label' => esc_html__('shape Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('scroll_down_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('SCROLL NOW', 'foresty-core'),
            'description' => esc_html__('enter button text', 'foresty-core')
        ]);
        $this->add_control('scroll_down_url', [
            'label' => esc_html__('Button url', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
            'description' => esc_html__('enter button url', 'foresty-core')
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="banner">
            <div class="banner__shape d-none d-xxl-block wow bounceInRight" data-wow-duration=".6s"
                data-wow-delay=".8s">
                <img src="<?php echo $settings['main_img']['url']; ?>" alt="shape">
            </div>
            <a href="<?php echo $settings['scroll_down_url']; ?>" class="banner__scroll-text"><span><?php echo $settings['scroll_down_text']; ?></span> <span class="banner__scroll-text-line"></span>
            </a>
            <div class="banner__leaf wow slideInLeft d-none d-md-block" data-wow-duration="1s" data-wow-delay="1s">
                <img src="<?php echo $settings['shape_img']['url']; ?>" alt="shape">
            </div>
            <div class="row">
                <div class="col-xl-4">
                    <div class="banner__image wow fadeInLeft" data-wow-duration="1.2s" data-wow-delay=".2s">
                        <img src="<?php echo $settings['left_img']['url']; ?>" alt="image">
                        <div class="banner__image-text">
                            <img src="<?php echo $settings['left_stock_img']['url']; ?>" alt="strock-text">
                        </div>
                    </div>
                </div>
                <div class="col-xl-8">
                    <div class="banner__content">
                        <h5 class="wow fadeInUp" data-wow-duration="1.2s" data-wow-delay=".2s"><?php echo $settings['sub_title']; ?></h5>
                        <h1 class="wow fadeInUp" data-wow-duration="1.4s" data-wow-delay=".4s">
                            <?php
                                $title = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['title']);
                                print wp_kses($title, foresty_core()->kses_allowed_html('all'));
                            ?>
                        </h1>
                        <div class="row g-4 align-items-center">
                            <div class="col-md-4">
                                <a href="<?php echo $settings['btn_url']; ?>" class="btn-one wow fadeInUp" data-wow-duration="1.5s"
                                    data-wow-delay=".5s"><span><?php echo $settings['btn_text']; ?></span> <i
                                        class="fa-solid fa-angles-right"></i></a>
                            </div>
                            <div class="col-md-8">
                                <div class="banner__content-con wow fadeInUp" data-wow-duration="1.6s"
                                    data-wow-delay=".6s">
                                    <img src="<?php echo get_template_directory_uri().'/assets/img/arrow-long.png'; ?>" alt="arrow">
                                    <p><?php echo $settings['content']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Banner_One_Widget());