<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Banner_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-banner-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner Two', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {   
        $this->start_controls_section(
            'sitebar_settings_section',
            [
                'label' => esc_html__('Menu General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'menu_right_text', [
                'label' => esc_html__('right text', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Get a Ticket', 'foresty-core'),
            ]
        );
        $this->add_control(
            'menu_right_url', [
                'label' => esc_html__('right text', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Get a Ticket', 'foresty-core'),
            ]
        );

        $this->add_control(
            'sitebar_logo', [
                'label' => esc_html__('Sitebar Logo Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('Upload Logo image', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_content', [
                'label' => esc_html__('content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We appreciate your trust greatly! minim veniam, consectetur adipiscing elit <br> We understand better that enim ad minim veniam, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_location', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Lavaca Street, Suite 2000', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_mail', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('trustemail@.com', 'foresty-core'),
            ]
        );
        $this->add_control(
            'sitebar_phone', [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('(+880) 01235 70051', 'foresty-core'),
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'sitebar_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'sitebar_url', [
                'label' => esc_html__('url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('sitebar_social_items', [
            'label' => esc_html__('sitebar social Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Banner General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'sub_title',
            [
                'label' => esc_html__('sub Title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Safeguarding Wildlife for Future Generations', 'foresty-core')
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('wildlife is the beauty  of earth', 'foresty-core')
            ]
        );
        $this->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Discover With Us', 'foresty-core'),
        ]);
        $this->add_control('btn_url', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
        ]);
        $this->add_control(
            'location',
            [
                'label' => esc_html__('location', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('85 Ketch Harbour RoadBensalem, PA 19020', 'foresty-core')
            ]
        );
        $this->add_control(
            'mail',
            [
                'label' => esc_html__('mail', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Info.company@gmail.com', 'foresty-core')
            ]
        );
        $this->add_control(
            'video_url',
            [
                'label' => esc_html__('video_url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('https://www.youtube.com/watch?v=Cn4G2lZ_g2I', 'foresty-core')
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'url', [
                'label' => esc_html__('url', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('#', 'foresty-core')
            ]
        );
        $this->add_control('banner_social_items', [
            'label' => esc_html__('banner social Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $banner_social_items = $settings['banner_social_items'];
        $sitebar_social_items = $settings['sitebar_social_items'];
        ?>

        <div class="body-overlay" id="body-overlay"></div>
        <!--sidebar menu start-->
        <div class="sidebar-menu" id="sidebar-menu">
            <button class="sidebar-menu-close"><i class="fa fa-times"></i></button>
            <div class="sidebar-inner">
                <div class="thumb mb-5">
                    <img src="<?php echo $settings['sitebar_logo']['url']; ?>" alt="logo"/>
                </div>
                <p>
                    <?php
                        $sitebar_content = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['sitebar_content']);
                        print wp_kses($sitebar_content, foresty_core()->kses_allowed_html('all'));
                    ?>
                </p>
                <div class="sidebar-address">
                    <h4 class="mb-3 pt-xl-4"><?php echo esc_html('Contact Us', 'foresty-core'); ?></h4>
                    <ul>
                        <li><i class="fa fa-map-marker-alt"></i><?php echo $settings['sitebar_location']; ?></li>
                        <li><i class="fa fa-envelope"></i><?php echo $settings['sitebar_mail']; ?></li>
                        <li><i class="fa fa-phone"></i><?php echo $settings['sitebar_phone']; ?></li>
                    </ul>
                </div>
                <h4 class="mb-4 pt-xl-4"><?php echo esc_html('Social Contact', 'foresty-core'); ?></h4>
                <ul class="social-media sitebar-social-media p-0 m-0">
                    <?php foreach ($sitebar_social_items as $items) { ?>
                        <li>
                            <a href="<?php echo $items['sitebar_url']; ?>">
                                <?php Icons_Manager::render_icon($items['sitebar_icon'], ['aria-hidden' => 'true']); ?>
                            </a>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
        <!--sidebar menu end-->

        <div class="banner-four pt-30 pb-30 bg-image">
            <div class="container">
                <div class="banner-four__wrp">
                    <div class="navbar-area-2 bg-relative">
                        <div class="row">
                            <div class="col-lg-2 align-self-center d-lg-block d-none">
                                <div class="cursor-pointer" id="navigation-button">
                                    <svg width="29" height="20" viewBox="0 0 29 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect width="24" height="2" fill="white"/>
                                    <rect y="9" width="29" height="2" fill="white"/>
                                    <rect y="18" width="18" height="2" fill="white"/>
                                    </svg>
                                </div>
                            </div>
                            <div class="col-lg-8">
                                <div class="navbar-area-inner text-lg-center">
                                    <nav class="navbar navbar-area navbar-expand-lg navigation-style-01 navbar-style-01 navbar-default">
                                        <div class="container custom-container">
                                            <div class="responsive-mobile-menu d-lg-none d-lg-inline-block">
                                                <div class="logo-wrapper">
                                                    <?php
                                                    $header_one_logo = cs_get_option('header_one_logo');
                                                    if (has_custom_logo() && empty($header_one_logo['id'])) {
                                                        the_custom_logo();
                                                    } elseif (!empty($header_one_logo['id'])) {
                                                        printf('<a class="site-logo" href="%1$s"><img src="%2$s" alt="%3$s"/></a>', esc_url(get_home_url()), $header_one_logo['url'], $header_one_logo['alt']);
                                                    } else {
                                                        printf('<a class="site-title" href="%1$s">%2$s</a>', esc_url(get_home_url()), esc_html(get_bloginfo('title')));
                                                    }
                                                    ?>
                                                </div>
                                                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#foresty_main_menu" aria-controls="foresty_main_menu" aria-expanded="false" aria-label="Toggle navigation">
                                                    <span class="navbar-toggler-icon"></span>
                                                </button>
                                            </div>
                                            <?php 
                                                wp_nav_menu(array(
                                                    'theme_location' => 'main-menu-2',
                                                    'menu_class' => 'navbar-nav text-lg-center',
                                                    'container' => 'div',
                                                    'container_class' => 'collapse navbar-collapse',
                                                    'container_id' => 'foresty_main_menu',
                                                    'fallback_cb' => 'foresty_theme_fallback_menu',
                                                ));
                                            ?>
                                        </div>
                                    </nav>
                                </div>
                            </div>
                            <div class="col-lg-2 align-self-center text-lg-end  d-lg-block d-none">
                                <a class="text-white" href="<?php echo $settings['menu_right_url']; ?>"><?php echo $settings['menu_right_text']; ?> <i class="fa fa-angle-double-right color-base"></i></a>
                            </div>
                        </div>
                    </div> 
                    <!-- navbar end-->

                    <!-- banner 2 start-->             
                    <div class="banner-four__content">
                        <h4 class="mb-40 wow fadeInUp" data-wow-duration="1.2s" data-wow-delay=".2s"><?php echo $settings['sub_title']; ?></h4>
                        <h1 class="wow fadeInUp" data-wow-duration="1.4s" data-wow-delay=".4s">
                            <?php echo $settings['title']; ?>
                        </h1>
                        <a href="<?php echo $settings['btn_url']; ?>" class="d-inline-block btn-one-white wow fadeInUp mt-60" data-wow-duration="1.8s" data-wow-delay=".8s">
                            <span><?php echo $settings['btn_text']; ?></span> <i class="fa-solid fa-angles-right"></i>
                        </a>
                    </div>
                    <div class="video-btn-right d-none d-md-block">
                        <div class="video-btn video-pulse">
                            <a class="video-play-btn video-popup secondary-bg" href="<?php echo $settings['video_url']; ?>">
                                <i class="fa-solid fa-play"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="banner-four__social d-none d-md-block">
                <?php foreach ($banner_social_items as $items) { ?>
                    <a href="<?php echo $items['url']; ?>">
                        <?php
                            Icons_Manager::render_icon($items['icon'], ['aria-hidden' => 'true']);
                        ?>
                    </a>
                <?php } ?>
            </div>
            <div class="banner-four__link d-none d-md-block">
                <a href="#0"><i class="fa-sharp fa-solid fa-paper-plane"></i> <?php echo $settings['mail']; ?></a>
                <a href="#0"><i class="fa-solid fa-location-dot"></i> <?php echo $settings['location']; ?></a>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Banner_Two_Widget());