<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Contact_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-contact-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Work Contact', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Have Something In Mind? Lets Talk.', 'foresty-core')
            ]
        );
        $this->add_control('content',
            [
                'label' => esc_html__('Content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Adipiscing Elit, Sed Do Eiusmod Tempor Incididunt Ut Labore Et Dolore Magna Aliqua. Ut Enim Ad Minim.', 'foresty-core')
            ]
        );
        $this->add_control('shape_img',
            [
                'label' => esc_html__('Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'c_icon', [
                'label' => esc_html__('icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-twitter',
                    'library' => 'solid',
                ],
            ]
        );
        $repeater->add_control(
            'c_title', [
                'label' => esc_html__('title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('785 15h Street, Office 478 Berlin', 'foresty-core')
            ]
        );
        $this->add_control('contact_items', [
            'label' => esc_html__('Contact Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $contact_items = $settings['contact_items'];
        ?>

        <div class="contact">
            <div class="content">
                <h2><?php echo $settings['title']; ?></h2>
                <p class="text-white"><?php echo $settings['content']; ?></p>
                <div class="arry"><img src="<?php echo $settings['shape_img']['url']; ?>" alt="img"></div>
                <ul class="p-0 m-0">
                    <?php foreach ($contact_items as $items) { ?>
                        <li>
                            <?php
                                Icons_Manager::render_icon($items['c_icon'], ['aria-hidden' => 'true']);
                            ?>
                            <?php echo $items['c_title']; ?>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Contact_Widget());