<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Line_Progress_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-line-progress-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Line Progress', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-skill-bar';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Carbon Offsetting', 'foresty-core')
            ]
        );
        $this->add_control('count_value',
            [
                'label' => esc_html__('count value', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('90', 'foresty-core')
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="experience-progress-wrapper">
            <div class="experience-progress pb-2">
                <div class="experience-title-wrapper d-flex align-items-center justify-content-between">
                    <h5 class="experience-title pb-2"><?php echo $settings['title']; ?></h5>
                    <span class="exp" style="left:<?php echo $settings['count_value']; ?>%">
                        <?php echo $settings['count_value']; ?>%
                    </span>
                </div>
                <div class="progress">
                    <div class="progress-bar wow slideInLeft" data-wow-duration=".8s" role="progressbar"
                        style="width: <?php echo $settings['count_value']; ?>%;" aria-valuenow="<?php echo $settings['count_value']; ?>0" aria-valuemin="0" aria-valuemax="100">
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Line_Progress_Widget());