<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Service_Contact_Info_Download_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-service-contact-info-download-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Service Contact Info Download', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('Download Brochures', 'foresty-core'),
            ]
        );
        $this->add_control(
            'content',
            [
                'label' => esc_html__('content', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => esc_html__('We Have Facility To Produce Advance Work Various Industrial Applications Based On', 'foresty-core'),
            ]
        );
        $this->add_control('btn_text', [
            'label' => esc_html__('Button Text', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('Contact Us', 'foresty-core'),
        ]);
        $this->add_control('btn_file', [
            'label' => esc_html__('Button File', 'foresty-core'),
            'type' => Controls_Manager::MEDIA,
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="service-single__right-item">
            <div class="item-three sub-bg">
                <div class="content">
                    <h4><?php echo $settings['title']; ?></h4>
                    <p><?php echo $settings['content']; ?>
                    </p>
                </div>
                <a class="d-inline-block" download href="<?php echo $settings['btn_file']['url']; ?>"><i class="fa-solid fa-arrow-down"></i> <?php echo $settings['btn_text']; ?></a>
            </div>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Service_Contact_Info_Download_Widget());