<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Tab_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-tab-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Tab One', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control('default_show_img',
            [
                'label' => esc_html__('default show Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                ),
                'description' => esc_html__('please add irst tab image', 'foresty-core'),
            ]
        );

        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'title', [
                'label' => esc_html__('title', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Carbon Offsetting', 'foresty-core')
            ]
        );
        $repeater->add_control(
            'content', [
                'label' => esc_html__('content', 'foresty-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tree planting is the act of planting young trees, shrubs, or other woody plants into the ground to establish new forests or enhance existing ones. It is a crucial component of environmental', 'foresty-core')
            ]
        );
        $repeater->add_control('main_img',
            [
                'label' => esc_html__('Main Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control('tab_one_items', [
            'label' => esc_html__('tab one Item', 'foresty-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                    'image' => array(
                        'url' => Utils::get_placeholder_image_src()
                    )
                ]
            ],
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $tab_one_items = $settings['tab_one_items'];
        ?>

        <div class="row g-4">
            <div class="col-xl-6">
                <div class="service__left-item">
                    <div class="accordion" id="accordionExample">
                        <?php 
                            $i = 0;
                            foreach ($tab_one_items as $item): 
                            $i++;

                            if ($i > 1) {
                                $collapsed = 'collapsed';
                            }else { 
                               $collapsed = ''; 
                            };

                            if ($i < 2) {
                                $show = 'show';
                            }else {
                               $show = ''; 
                            };
                        ?>
                            <div class="accordion-item wow fadeInUp" data-wow-duration="1.2s" data-wow-delay=".2s">
                                <h2 class="accordion-header" id="heading<?php echo $i; ?>">
                                    <button class="accordion-button changeImage <?php echo $collapsed; ?>"
                                        data-image="<?php echo $item['main_img']['url']; ?>" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>" aria-expanded="true"
                                        aria-controls="collapse<?php echo $i; ?>">
                                        <?php echo $item['title']; ?>
                                    </button>
                                </h2>
                                <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show; ?>"
                                    aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p><?php echo $item['content']; ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 wow fadeInDown" data-wow-duration="1.8s" data-wow-delay=".4s">
                <div class="image">
                    <img id="myImage" src="<?php echo $settings['default_show_img']['url']; ?>" alt="image">
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Tab_One_Widget());