<?php
/**
 * Elementor Widget
 * @package Foresty
 * @since 1.0.0
 */

namespace Elementor;
class Foresty_Work_One_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'foresty-work-one-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Work One', 'foresty-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image-rollover';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['foresty_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'foresty-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('main_img',
            [
                'label' => esc_html__('Main svg Image/ icon', 'foresty-core'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-phone-alt',
                    'library' => 'solid',
                ],
            ]
        );
        $this->add_control('shape_img',
            [
                'label' => esc_html__('shape Image', 'foresty-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src()
                )
            ]
        );
        $this->add_control(
            'count_number',
            [
                'label' => esc_html__('count', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter count.', 'foresty-core'),
                'default' => esc_html__('01', 'foresty-core')
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'description' => esc_html__('enter title.', 'foresty-core'),
                'default' => esc_html__('Community Forestry', 'foresty-core')
            ]
        );
        $this->add_control('content',
            [
                'label' => esc_html__('Description', 'foresty-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('We maintain a busy network of forestry and social development staff along with local
                    facilitators in the areas we work.', 'foresty-core')
            ]
        );
        $this->add_control('btn_url', [
            'label' => esc_html__('Button Link', 'foresty-core'),
            'type' => Controls_Manager::TEXT,
            'default' => esc_html__('#', 'foresty-core'),
            'description' => esc_html__('enter button link', 'foresty-core')
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <div class="wow fadeInDown" data-wow-duration="1.2s" data-wow-delay=".2s">
            <div class="work__item mb-4">
                <div class="work__item-icon">
                    <?php
                        Icons_Manager::render_icon($settings['main_img'], ['aria-hidden' => 'true']);
                    ?>
                    <span><?php echo $settings['count_number']; ?></span>
                </div>
                <h4><a href="<?php echo $settings['btn_url']; ?>"><?php echo $settings['title']; ?></a></h4>
                <p><?php echo $settings['content']; ?></p>
                <a class="work__item-arrow" href="<?php echo $settings['btn_url']; ?>"><i class="fa-solid fa-arrow-right"></i></a>
                <div class="work__item-leaf">
                    <img src="<?php echo $settings['shape_img']['url']; ?>" alt="img">
                </div>
            </div>
        </div>

        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Foresty_Work_One_Widget());