<?php
/*
Plugin Name: Foresty Core
Plugin URI: https://themeforest.net/user/gramentheme/portfolio
Description: Plugin to contain short codes and custom post types of the Foresty theme.
Author: Gramentheme
Author URI: https://gramentheme.com/
Version: 1.0.2
Text Domain: foresty-core
*/


/**
 * If this file is called directly, abort.
 * @package foresty
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**
 * Plugin directory path
 * @package foresty
 * @since 1.0.0
 */
define( 'FORESTY_CORE_ROOT_PATH', plugin_dir_path( __FILE__ ) );
define( 'FORESTY_CORE_ROOT_URL', plugin_dir_url( __FILE__ ) );
define( 'FORESTY_CORE_SELF_PATH', 'foresty-core/foresty-core.php' );
define( 'FORESTY_CORE_VERSION', '2.1.2' );
define( 'FORESTY_CORE_INC', FORESTY_CORE_ROOT_PATH .'/inc');
define( 'FORESTY_CORE_LIB', FORESTY_CORE_ROOT_PATH .'/lib');
define( 'FORESTY_CORE_ELEMENTOR', FORESTY_CORE_ROOT_PATH .'/elementor');
define( 'FORESTY_CORE_DEMO_IMPORT', FORESTY_CORE_ROOT_PATH .'/demo-import');
define( 'FORESTY_CORE_ADMIN', FORESTY_CORE_ROOT_PATH .'/admin');
define( 'FORESTY_CORE_ADMIN_ASSETS', FORESTY_CORE_ROOT_URL .'admin/assets');
define( 'FORESTY_CORE_WP_WIDGETS', FORESTY_CORE_ROOT_PATH .'/wp-widgets');
define( 'FORESTY_CORE_ASSETS', FORESTY_CORE_ROOT_URL .'assets/');
define( 'FORESTY_CORE_CSS', FORESTY_CORE_ASSETS .'css');
define( 'FORESTY_CORE_JS', FORESTY_CORE_ASSETS .'js');
define( 'FORESTY_CORE_IMG', FORESTY_CORE_ASSETS .'img');


/**
 * Load additional helpers functions
 * @package foresty
 * @since 1.0.0
 */
if (!function_exists('foresty_core')){
	require_once FORESTY_CORE_INC .'/theme-core-helper-functions.php';
	if (!function_exists('foresty_core')){
		function foresty_core(){
			return class_exists('Foresty_Core_Helper_Functions') ? new Foresty_Core_Helper_Functions() : false;
		}
	}
}
//ob flash
remove_action( 'shutdown', 'wp_ob_end_flush_all', 1 );


/**
 * Load Codestar Framework Functions
 * @package foresty
 * @since 1.0.0
 */
if ( !foresty_core()->is_foresty_active()) {
	if ( file_exists( FORESTY_CORE_ROOT_PATH . '/inc/csf-functions.php' ) ) {
		require_once FORESTY_CORE_ROOT_PATH . '/inc/csf-functions.php';
	}
}



/**
 * Core Plugin Init
 * @package foresty
 * @since 1.0.0
 */
if ( file_exists( FORESTY_CORE_ROOT_PATH . '/inc/theme-core-init.php' ) ) {
	require_once FORESTY_CORE_ROOT_PATH . '/inc/theme-core-init.php';
}
