<?php
/**
 * Theme Social Share Widget
 * @package Foresty
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('foresty_social_share_widget', array(
        'title' => esc_html__('Foresty: Social Share', 'foresty-core'),
        'classname' => 'foresty-social-share-about',
        'description' => esc_html__('Display Social Share widget', 'foresty-core'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'foresty-core'),
                'default' => esc_html__('Never Miss News', 'foresty-core')
            ),
            array(
                'id' => 'foresty-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social Icon', 'foresty-core'),
                'fields' => array(
                    array(
                        'id' => 'foresty-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'foresty-core'),
                        'default' => 'fab fa-facebook'
                    ),
                    array(
                        'id' => 'foresty-social-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'foresty-core'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));


    if (!function_exists('foresty_social_share_widget')) {
        function foresty_social_share_widget($args, $instance)
        {

            echo $args['before_widget'];
            

            $heading_title = $instance['heading'] ?? '';
            $socialIcon = is_array($instance['foresty-social-icon-repeater']) && !empty($instance['foresty-social-icon-repeater']) ? $instance['foresty-social-icon-repeater'] : [];


            ?>
            <div class="social-share-widget">
                <h4 class="widget-headline"><?php echo esc_html($heading_title); ?></h4>
                <ul class="social-icon style-03">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a href="%2$s"><i class="%1$s"></i></a></li>', esc_html($icon['foresty-social-icon']), esc_url($icon['foresty-social-text']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>